--[[ LUA BASICS
	-- Syntax
		- You define comments using two dashes like -- Comment is after here
		- You define a multi-line comment using two dashes than two brackets and then end with two brackets such as [[ Comment is in here ]]
			- NOTE: You cannot have a space between the dashes and the brackets
		- You define non-number values with quotes like "black"
		- If you want a multi-line non-number value, use brackets as you would in a comment [[ black ]]

	-- Variables
		- These are things like PositionX which you can set to something like 320
		- If you set PositionX to 320, then anytime you use the text PositionX, it will act as if you're putting the number 320
		- You can even have a negative -320 by doing local PositionX = -320
		- Even better yet, you can just do the negative in your command such as cmd(x,-PositionX;y,-PositionY)
		- Why is this good? Because you can change the value PositionX is instead of having to go through and change the number 320 a bunch of times
		
	-- Scope
		- The word 'local' definies something for just this screen
		- Example "local PositionX"
		- It makes it so the PositionX on this screen won't affect the PositionX on another
		
	-- Tables
		- Almost everything in Lua is done in tables <- REMEMBER THIS
		- You can assume the tables we're working with are 1 column almost all the time
		- You find out which row you want from LayerTable by doing LayerTable[i] where i is the row number
		- NOTE: All row numbers start at 1; there is no way around this
	
	-- Table Lengths
		- You can find the last item in the table LayerTable by going to LayerTable[#LayerTable] where #LayerTable is the length of the table
		- If you have 3 objects in LayerTable, then #LayerTable will be 3
		- So if you want to find the last object, you could either do LayerTable[3] or LayerTable[#LayerTable]
		- It's best to use the hash (#) if you can because you will not always know the length of your table
		- This is important because it helps understand what's going on
		- TRICK: You can do math inside for the brackets like LayerTable[#LayerTable+1] which means it'll find the first entry after the very last one in the tabel which will always be blank
		
	-- Table Values
		- With the very last line of a table, commas are optional
		- EXAMPLE1:
				LayerTable = {
					Value1,
					Value2,
					Value3
				}
		- I just defined a table called LayerTable and it now has 3 values
		- I can access Value2 by doing LayerTable[2]
		- You can have tables in tables and other things which are way more complicated than I am going into
		- NOTE: You can easily figure out what a table is by the curly brackets
		- EXAMPLE2:
			Def.ActorFrame {
				LoadActor("fun"),
				LoadActor("cake"),
				Def.ActorFrame{
					InitCommand=cmd(Center)
				}
			}
		- This is also a table the StepMania way
		- Notice how the very last parts of the table do not contain commas; this is because they are optional
		- NOTE: In most SSC lua code, you'll notice semicolons all over the place
			- These are not needed and are not recommended
			- In some cases, they can be replaced with commas like the insides of tables
			- In other places, they're not needed at all like outside of tables
]]

--[[ Defining Variables ]]--
-- Defining the X position as 320 because just about everything here uses it
local PositionX = 320

-- Not defining a single Y position because they're always changing so I'm making a few
-- EDIT by MissingnoForce: again, using variables instead of fix positions, reason see above
local PositionYSuperNOVA = 200
local PositionYGAMESTART = 120
local PositionYOPTIONSMENU = 170
local PositionYEDITMODE = 220
local PositionYJUKEBOX = 270
local PositionYEXIT = 320

-- Since the zoom is only 2, I'm assuming it's preferred they're all the same
local ZoomSuperNOVA = 2

-- While we're at it, why not make one for the font name too?
local FontChoice = "_shared1"
local FontChoiceOther = "Common normal"

---------------------------

--[[ Defining Tables ]]--

-- Defining the table which I'm calling LayerTable
local LayerTable

--[[ Creating an ActorFrame which we're making part of the table named LayerTable
	- #LayerTable means the length of the table which in this case is 0 because we haven't put anything in it until now
	- We do #LayerTable+1 because we're incrementing the length of the table, which is 0, by one so now this is the first item
	- Why does this matter? Because we are going to return the entire table to the screen at the end
	- This is not centered so you don't need addx and addy
]]
LayerTable[#LayerTable+1] = Def.ActorFrame {
	
	--[[ My code uses B() as a function I wrote to make this cleaner and easier to write which you can copy/paste in your Scripts directory if you want to use it my way
		- Do not worry about it too much, but G() is for the Graphics folder and B() is for the BGAnimations folder, F() for Fonts etc
		- We put the image name in quotes
			- We're assuming here the image is in the BGAnimations folder
		- The .. means you are using a concatination
			- Don't worry about why, just know you need it when loading fonts or actors
		- The { } enclose the contents you nomrally have in the Command= area
			- Saying it again, always put a comma after every command inside of a frame because this is actually a tabel of objects
			- This includes the final curly bracket
	]]
	LoadActor(B("_white")) .. {
	
		-- FullScreen is another SSC shortcut which makes anything which contains it fill the whole screen
		InitCommand=cmd(FullScreen)
	},

	LoadActor("SupernovaGreen.png") .. {

		--[[ What did I do?
			- Yay for copy/paste; this is only possible because of cmd()
			- Notice my PositionX can also be negative
			- I replaced addx and addy with just x and y because these are in their own, non-centered, layer
			- Second, the SSC guys have another shortcut, xy which makes it so you can do xy,X,Y;spin
			- Also notice here I am using PositionYSuperNOVA for the first time
			- I put things on multiple lines so they're easier to read
		]]
		InitCommand=cmd(
			zoom,ZoomSuperNOVA;
			xy,-PositionX,PositionYSuperNOVA;
			spin
		)
	},
	
	LoadActor("SupernovaRed.png") .. {
	
		
		InitCommand=cmd(
			zoom,ZoomSuperNOVA;
			xy,PositionX,PositionYSuperNOVA;
			spin
		)
	},
	LoadActor("SupernovaBlue.png") .. {
		InitCommand=cmd(
			zoom,ZoomSuperNOVA;
			y,-PositionYSuperNOVA;
			spin
		)
	}

-- This is the Centered layer so everything that we put inside of here will be centered
LayerTable[#LayerTable+1] = Def.ActorFrame {

	--[[ InitCommand stands for Initial Command
		- This is what happens when you first load a screen
			- OnCommand is for when something is enabled on the screen
			- You will mostly use InitCommand when converting 3.9 themes
		- As you'll see further down, cmd() is a way to emulate the 3.9 way of things without using function(self)
		- Center is something the SSC guys wrote in which basically centers this object, the frame, in one simple command
		- Always put a comma after every command inside of a frame because this is actually a tabel of objects
	]]
	InitCommand=cmd(Center),

	--[[ Changes to fonts
		- Using our FontChoice variable which I defined in the --[[ Variables ]] area so we don't have to keep putting "_shared1" in there
		- Good to also note, the LoadFont() command actually loads from the Fonts directory so we don't need to define F() for the directory like we do sometimes with LoadActor()
		- EXAMPLE of defining the fonts directory explicitly: LoadFont(F(FontChoice)) which still works
	]]
	LoadFont(FontChoice) .. {
		
		-- There are a few ways to set the text, this is the easiest
		Name="GAME START",
		
		-- Notice the commas now because we're inside a set of curly brackets so that means this is another table
		OnCommand=cmd(
			xy,PositionX,PositionYGAMESTART;
			shadowlength,0;
			cropright,1.3;
			faderight,0.1;
			linear,0.7;
			cropright,-0.3
		),
		OffCommand=cmd(
			xy,PositionX,PositionYGAMESTART;
			shadowlength,0;
			cropleft,-0.3;
			fadeleft,0.1;
			linear,0.7;
			cropleft,1.3
		)
	},

	LoadFont(FontChoice) .. {
		
		-- There are a few ways to set the text, this is the easiest
		Name="OPTIONS MENU",
		
		--[[ Notice the commas now because we're inside a set of curly brackets so that means this is another table
			- Notice I put 0.25 for the sleep command
			- You don't need the 0, but it's best to keep it there
		]]
		OnCommand=cmd(
			xy,PositionX,PositionYOPTIONSMENU;
			shadowlength,0;
			diffusealpha,0;
			sleep,0.25;
			diffusealpha,1;
			cropright,1.3;
			faderight,0.1;
			linear,0.7;
			cropright,-0.3
		),
		OffCommand=cmd(
			xy,PositionX,PositionYOPTIONSMENU;
			shadowlength,0;
			sleep,0.25;
			cropleft,-0.3;
			fadeleft,0.1;
			linear,0.7;
			cropleft,1.3
		)
	},
	
	--[[ Okay, first try (with a little copypasta):
		
		
		[Layer7]
		Text=EDIT MODE
		File=_shared1
		OnCommand=x,PositionX;y,220;shadowlength,0;diffusealpha,0;sleep,.5;diffusealpha,1;cropright,1.3;faderight,0.1;linear,0.7;cropright,-0.3
		OffCommand=x,PositionX;y,220;shadowlength,0;sleep,.5;cropleft,-0.3;fadeleft,0.1;linear,0.7;cropleft,1.3 ]]
		
		LoadFont(FontChoice) .. {
		
		Name="EDIT MODE",
		
		OnCommand=cmd(
			xy,PositionX,PositionYEDITMODE;
			shadowlength,0;
			diffusealpha,0;
			cropright,1.3;
			faderight,0.1;
			sleep,0.5;
			linear,0.7;
			cropright,-0.3
		),
		OffCommand=cmd(
			xy,PositionX,PositionYEDITMODE;
			shadowlength,0;
			cropleft,-0.3;
			fadeleft,0.1;
			sleep,0.5;
			linear,0.7;
			cropleft,1.3
		)
	},

	--[[ Next Layer:
		
		[Layer8]
		Text=SUPERNOVA JUKEBOX
		File=_shared1
		OnCommand=x,PositionX;y,270;shadowlength,0;diffusealpha,0;sleep,.75;diffusealpha,1;cropright,1.3;faderight,0.1;linear,0.7;cropright,-0.3
		OffCommand=x,PositionX;y,270;shadowlength,0;sleep,.75;cropleft,-0.3;fadeleft,0.1;linear,0.7;cropleft,1.3 ]]

	LoadFont(FontChoice) .. {
	
		Name"SUPERNOVA JUKEBOX"
		
		OnCommand=cmd(
			xy,PositionX,PositionYJUKEBOX;
			shadowlength,0;
			diffusealpha,0;
			cropright,1.3;
			faderight,0.1;
			sleep,0.75;
			diffusealpha,1;
			linear,0.7;
			cropright,-0.3;
		),
		OffCommand=cmd(
			xy,PositionX,PositionYJUKEBOX;
			shadowlength,0;
			sleep,0.75;
			cropleft,-0.3;
			fadeleft,0.1;
			linear,0.7;
			cropleft,1.3;
		)
	},
		
	--[[ The Last Choice:
	
		[Layer9]
		Text=EXIT SUPERNOVA
		File=_shared1
		OnCommand=x,PositionX;y,320;shadowlength,0;diffusealpha,0;sleep,1;diffusealpha,1;cropright,1.3;faderight,0.1;linear,0.7;cropright,-0.3
		OffCommand=x,PositionX;y,320;shadowlength,0;sleep,1;cropleft,-0.3;fadeleft,0.1;linear,0.7;cropleft,1.3 ]]
		
		LoadFont(FontChoice) .. {
		
			Name="EXIT SUPERNOVA"
			
			OnCommand=cmd(
				xy,PositionX,PositionYEXIT;
				shadowlength,0;
				diffusealpha,0;
				cropright,1.3;
				faderight,0.1;
				sleep,1;
				diffusealpha,1;
				linear,0.7;
				cropright,-0.3;
			),
			OffCommand=cmd(
				xy,PositionX,PositionYEXIT;
				shadowlength,0;
				sleep,1;
				cropleft,-0.3;
				fadeleft,0.1;
				linear,0.7;
				cropleft,1.3;
		)
	},

	--[[ The "Header" of the TitleMenu:
			
		[Layer10]
		Text=StepMania Supernova Theme
		File=_shared1
		Command=x,PositionX;y,50;glowshift ]]

		LoadFont(FontChoice) .. {
		
			Name="StepMania Supernova Theme"
			
			OnCommand=cmd(
				xy,PositionX,75;
				glowshift;
			)
		},
		
	--[[ The Second "Header" part, no glowshift applied:
	
		[Layer11]
		Text=Main Menu
		File=_shared1
		Command=x,PositionX;y,75 ]]
		
		LoadFont(FontChoice) .. {
		
			Name="Main Menu"
			
			OnCommand=cmd(
			xy,PositionX,75;
		)
	},

		
	-- Using FontChoiceOther this time because the font is "Common normal"	
	LoadFont(FontChoiceOther) .. {
		
		-- There are a few ways to set the text, this is the easiest
		Name="Make a selection",
		
		--[[ Notice the commas now because we're inside a set of curly brackets so that means this is another table
			- Notice I put 0.25 for the sleep command
			- You don't need the 0, but it's best to keep it there
		]]
		InitCommand=cmd(
			xy,PositionX,400;
			rainbow; -- Rainbow isn't in SM5. I have no clue what this does
			effectperiod,1.5
		),
	},
			
	--[[ And, last but not least, the last decoration
	
		[Layer13]
		Text=Theme Version 3
		File=Common normal
		Command=x,PositionX+130;y,20;zoom,0.5;shadowlength,2;diffuse,#808080 ]]
		
	LoadFont (FontChoiceOther) .. {
	
		Name="Theme Version 3"
		
		InitCommand=cmd(
			xy,PositionX+130,20;
			zoom,0.5;
			shadowlength,2;
			diffuse,#808080;
		),
	},

	
	
-- Closing curly bracket is very important not to forgot
}

--[[ At the very end, we say "return LayerTable"
	- This means we're returning this to the game now that we're done processing it so the game can display it
	- Return statements generally go at the end of screens, but in some cases like with functions or conditionals, this might not be the case
	- For now assume they're always at the bottom
]]
return LayerTable

-- I always leave a bunch of space down here so I have more room to scroll down and see what's going on








